public class Binaerbaum<T extends Comparable<T>> {
  // Der Schluessel
  private T key;
  // Das linke Kind
  private BinaryTree<T> leftChild;
  // Das rechte Kind
  private BinaryTree<T> rightChild;
  // Der Elternknoten
  private BinaryTree<T> parent;

  // Konstruktor
  public BinaryTree(T key, BinaryTree<T> parent) {
    this.key = key;
    this.parent = parent;
  }

  // Fuege ein Element ein
  public void insert(T element) {
    insert(new BinaryTree<T>(element, null));
  }

  // Fuege einen Teilbaum an der richtigen Stelle ein
  public void insert(BinaryTree<T> node) {
    if (node.key.compareTo(key) <= 0) {
      // Links einfuegen
      if (leftChild == null) {
        // Als linkes Kind einfuegen
        leftChild = node;
        node.parent = this; // Elternverweis korrekt setzen
      } else {
        // Beim linken Kind einfuegen
        leftChild.insert(node);
      }
    } else {
      // Rechts einfuegen
      if (rightChild == null) {
        // Als rechtes Kind einfuegen
        rightChild = node;
        node.parent = this; // Elternverweis korrekt setzen
      } else {
        // Beim rechten Kind einfuegen
        rightChild.insert(node);
      }
    }
  }

  // Suche ein Element und gebe es aus, falls gefunden.
  // Ansonsten gebe null zurueck.
  public T search(T element) {
    // Element gefunden?
    if (element.compareTo(key) == 0) {
      return element;
    }
    if (element.compareTo(key) < 0) {
      // Links suchen
      if (leftChild != null) {
        return leftChild.search(element);
      }
    } else {
      // Rechts suchen
      if (rightChild != null) {
        return rightChild.search(element);
      }
    }
    // Element nicht gefunden
    return null;
  }

  // Ersetze ein Kind durch einen Teilbaum
  private void replaceChild(BinaryTree<T> child, BinaryTree<T> replacement) {
    if (leftChild == child) {
      leftChild = replacement;
    } else if (rightChild == child) {
      rightChild = replacement;
    }
  }

  // Entferne den Knoten mit dem angegebenen Element
  public void delete(T element) {
    // Dieser Knoten muss geloescht werden
    if (element.compareTo(key) == 0) {
      // Fall 1: Keine Kinder, Knoten einfach loeschen
      if (leftChild == null && rightChild == null) {
        parent.replaceChild(this, null);
      }
      // Fall 2: Nur rechtes Kind, Knoten durch rechtes Kind ersetzen
      else if (leftChild == null && rightChild != null) {
        parent.replaceChild(this, rightChild);
      }
      // Fall 3: Nur linkes Kind, Knoten durch linkes Kind ersetzen
      else if (leftChild != null && rightChild == null) {
        parent.replaceChild(this, leftChild);
      }
      // Fall 4: Zwei Kinder
      else {
        // Knoten durch linkes Kind ersetzen
        parent.replaceChild(this, leftChild);
        // Rechtes Kind beim linken Kind einfuegen
        leftChild.insert(rightChild);
      }
    }

    // Ein Kindknoten muss geloescht werden
    if (element.compareTo(key) <= 0) {
      // Links loeschen
      if (leftChild != null) {
        leftChild.delete(element);
      }
    } else {
      // Rechts loeschen
      if (rightChild != null) {
        rightChild.delete(element);
      }
    }
  }

  // Liefere eine String Repräsentation
  public String toString() {
    String result = key + ":[";
    if (leftChild != null) {
      result += leftChild;
    }
    if (rightChild != null) {
      result += ";";
      result += rightChild;
    }	
    result += "]";
    return result;
  }

  public static void main(String[] args) {
    // Einfuegen
    BinaryTree<Integer> b = new BinaryTree<Integer>(42, null);
    b.insert(36);
    b.insert(3);
    b.insert(77);
    b.insert(41);
    b.insert(1);
    b.insert(99);
    System.out.println(b);

    // Suchen
    System.out.println(b.search(41));
    System.out.println(b.search(43));

    // Loeschen
    b.delete(36);
    System.out.println(b);
  }
}